package gov.va.med.mhv.health.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class HealthHistoryRecordDTO implements Serializable {

	private static final long serialVersionUID = 8970045395067147490L;

	private Long id;

	// General Fields
	private String relationship;
	private String firstName;
	private String lastName;
	private boolean living = true;
	private String comments;

	// Airway/Breathing Conditions
	private boolean awAsthma;
	private boolean awBronchitis;
	private boolean awCOPD;
	private boolean awEmphysema;
	private boolean awPneumonia;
	private boolean awSoB;
	private boolean awTuberculosis;
	private boolean awOther;

	// Allergy/Immune Systen Conditions
	private boolean alAllergies;
	private boolean alLupus;
	private boolean alOther;

	// Alcohol Conditions
	private boolean alcSocial;
	private boolean alcOneDrink;
	private boolean alcSixDrinks;
	private boolean alcTwoShots;

	// Blood Disorders
	private boolean blAnemia;
	private boolean blBruising;
	private boolean blClotting;
	private boolean blLeukemia;
	private boolean blSickleCell;
	private boolean blOther;

	// Body Aches
	private boolean baArthritis;
	private boolean baFibromyalgia;
	private boolean baJointPain;
	private boolean baLymeDisease;
	private boolean baOther;

	// Cancers
	private boolean caBreast;
	private boolean caBowel;
	private boolean caColon;
	private boolean caLung;
	private boolean caOvarian;
	private boolean caSkin;
	private boolean caStomach;
	private boolean caProstate;
	private boolean caOther;

	// Childhood Diseases
	private boolean chChickenPox;
	private boolean chDiphtheria;
	private boolean chMeasles;
	private boolean chMumps;
	private boolean chWhoopingCough;
	private boolean chOther;

	// Diabetes -
	private boolean dbType1;
	private boolean dbType2;
	private boolean dbType3;

	// Gallbladder
	private boolean gbDisease;
	private boolean gbStones;
	private boolean gbOther;

	// Head, Eyes, etc.
	private boolean hntCataracts;
	private boolean hntDizziness;
	private boolean hntDyslexia;
	private boolean hntGlaucoma;
	private boolean hntHearingLoss;
	private boolean hntMigraineHeadaches;
	private boolean hntRetinitisPigmentosa;
	private boolean hntOther;

	// Heart/Cardiovascular
	private boolean heAngina;
	private boolean heCongestiveFailure;
	private boolean heAttack;
	private boolean heMurmur;
	private boolean heHighCholesterol;
	private boolean heHighPressure;
	private boolean heMitralValveProlapse;
	private boolean heRhythmAbnormality;
	private boolean heStroke;
	private boolean heOther;

	// Kidney
	private boolean kiInfections;
	private boolean kiStones;
	private boolean kiRenalFailure;
	private boolean kiOther;

	// Liver
	private boolean liHepatitisA;
	private boolean liHepatitisB;
	private boolean liHepatitisC;
	private boolean liCirrhosis;
	private boolean liOther;

	// Mood/Cognitive
	private boolean mdAnxiety;
	private boolean mdBipolar;
	private boolean mdDepression;
	private boolean mdParanoia;
	private boolean mdPTSD;
	private boolean mdSchizophrenia;
	private boolean mdOther;

	// Mood/Cognitive
	private boolean nvEpilepsy;
	private boolean nvMultipleSclerosis;
	private boolean nvNumbness;
	private boolean nvParalysis;
	private boolean nvSeizures;
	private boolean nvOther;

	// Nose Bleeds
	private boolean nbOnePerMonth;
	private boolean nbOnePerWeek;
	private boolean nbOnePerDay;

	// Pain
	private boolean pnBack;
	private boolean pnJoint;
	private boolean pnMuscle;
	private boolean pnLeg;
	private boolean pnOther;

	// Skin Disorders
	private boolean skEczema;
	private boolean skPsoriasis;
	private boolean skOther;

	// Sleep Disorders
	private boolean slInsomnia;
	private boolean slApnea;
	private boolean slOther;

	// Smoking History
	private boolean smCurrent;
	private boolean smOnePackPerDay;
	private boolean smTenYears;
	private boolean smTwentyYears;

	// STDs
	private boolean stdChlamydia;
	private boolean stdGonorrhea;
	private boolean stdHerpes;
	private boolean stdSyphilis;
	private boolean stdOther;

	// Stomach, Bowel
	private boolean stmIBS;
	private boolean stmNausea;
	private boolean stmPain;
	private boolean stmSevereIndigestion;
	private boolean stmUlcers;
	private boolean stmOther;

	// Thyroid
	private boolean thGoiter;
	private boolean thTumor;
	private boolean thOther;

	// Weight
	private boolean wtOverweight;
	private boolean wtUnderweight;

	private Integer oplock = 1;
	private Long userprofileId;

	private List<OtherHealthIssueDTO> otherHealthIssues = new ArrayList<OtherHealthIssueDTO>(0);

	/**
	 * @return the id
	 */
	public Long getId() {
		return id;
	}

	/**
	 * @param id the id to set
	 */
	public void setId(Long id) {
		this.id = id;
	}

	/**
	 * @return the relationship
	 */
	public String getRelationship() {
		return relationship;
	}

	/**
	 * @param relationship the relationship to set
	 */
	public void setRelationship(String relationship) {
		this.relationship = relationship;
	}

	/**
	 * @return the firstName
	 */
	public String getFirstName() {
		return firstName;
	}

	/**
	 * @param firstName the firstName to set
	 */
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	/**
	 * @return the lastName
	 */
	public String getLastName() {
		return lastName;
	}

	/**
	 * @param lastName the lastName to set
	 */
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	/**
	 * @return the living
	 */
	public boolean getLiving() {
		return living;
	}

	/**
	 * @param integer the living to set
	 */
	public void setLiving(boolean integer) {
		this.living = integer;
	}

	/**
	 * @return the comments
	 */
	public String getComments() {
		return comments;
	}

	/**
	 * @param comments the comments to set
	 */
	public void setComments(String comments) {
		this.comments = comments == null ? "" : comments;
	}

	/**
	 * @return the awAsthma
	 */
	public boolean getAwAsthma() {
		return awAsthma;
	}

	
	/**
	 * @param awAsthma the awAsthma to set
	 */
	public void setAwAsthma(boolean awAsthma) {
		this.awAsthma = awAsthma;
	}

	/**
	 * @return the awBronchitis
	 */
	public boolean getAwBronchitis() {
		return awBronchitis;
	}

	/**
	 * @param awBronchitis the awBronchitis to set
	 */
	public void setAwBronchitis(boolean awBronchitis) {
		this.awBronchitis = awBronchitis;
	}

	/**
	 * @return the awCOPD
	 */
	public boolean getAwCOPD() {
		return awCOPD;
	}

	/**
	 * @param awCOPD the awCOPD to set
	 */
	public void setAwCOPD(boolean awCOPD) {
		this.awCOPD = awCOPD;
	}

	/**
	 * @return the awEmphysema
	 */
	public boolean getAwEmphysema() {
		return awEmphysema;
	}

	/**
	 * @param awEmphysema the awEmphysema to set
	 */
	public void setAwEmphysema(boolean awEmphysema) {
		this.awEmphysema = awEmphysema;
	}

	/**
	 * @return the awPneumonia
	 */
	public boolean getAwPneumonia() {
		return awPneumonia;
	}

	/**
	 * @param awPneumonia the awPneumonia to set
	 */
	public void setAwPneumonia(boolean awPneumonia) {
		this.awPneumonia = awPneumonia;
	}

	/**
	 * @return the awSoB
	 */
	public boolean getAwSoB() {
		return awSoB;
	}

	/**
	 * @param awSoB the awSoB to set
	 */
	public void setAwSoB(boolean awSoB) {
		this.awSoB = awSoB;
	}

	/**
	 * @return the awTuberculosis
	 */
	public boolean getAwTuberculosis() {
		return awTuberculosis;
	}

	/**
	 * @param awTuberculosis the awTuberculosis to set
	 */
	public void setAwTuberculosis(boolean awTuberculosis) {
		this.awTuberculosis = awTuberculosis;
	}

	/**
	 * @return the awOther
	 */
	public boolean getAwOther() {
		return awOther;
	}

	/**
	 * @param awOther the awOther to set
	 */
	public void setAwOther(boolean awOther) {
		this.awOther = awOther;
	}

	/**
	 * @return the alAllergies
	 */
	public boolean getAlAllergies() {
		return alAllergies;
	}

	/**
	 * @param alAllergies the alAllergies to set
	 */
	public void setAlAllergies(boolean alAllergies) {
		this.alAllergies = alAllergies;
	}

	/**
	 * @return the alLupus
	 */
	public boolean getAlLupus() {
		return alLupus;
	}

	/**
	 * @param alLupus the alLupus to set
	 */
	public void setAlLupus(boolean alLupus) {
		this.alLupus = alLupus;
	}

	/**
	 * @return the alOther
	 */
	public boolean getAlOther() {
		return alOther;
	}

	/**
	 * @param alOther the alOther to set
	 */
	public void setAlOther(boolean alOther) {
		this.alOther = alOther;
	}

	/**
	 * @return the alcSocial
	 */
	public boolean getAlcSocial() {
		return alcSocial;
	}

	/**
	 * @param alcSocial the alcSocial to set
	 */
	public void setAlcSocial(boolean alcSocial) {
		this.alcSocial = alcSocial;
	}

	/**
	 * @return the alcOneDrink
	 */
	public boolean getAlcOneDrink() {
		return alcOneDrink;
	}

	/**
	 * @param alcOneDrink the alcOneDrink to set
	 */
	public void setAlcOneDrink(boolean alcOneDrink) {
		this.alcOneDrink = alcOneDrink;
	}

	/**
	 * @return the alcSixDrinks
	 */
	public boolean getAlcSixDrinks() {
		return alcSixDrinks;
	}

	/**
	 * @param alcSixDrinks the alcSixDrinks to set
	 */
	public void setAlcSixDrinks(boolean alcSixDrinks) {
		this.alcSixDrinks = alcSixDrinks;
	}

	/**
	 * @return the alcTwoShots
	 */
	public boolean getAlcTwoShots() {
		return alcTwoShots;
	}

	/**
	 * @param alcTwoShots the alcTwoShots to set
	 */
	public void setAlcTwoShots(boolean alcTwoShots) {
		this.alcTwoShots = alcTwoShots;
	}

	/**
	 * @return the blAnemia
	 */
	public boolean getBlAnemia() {
		return blAnemia;
	}

	/**
	 * @param blAnemia the blAnemia to set
	 */
	public void setBlAnemia(boolean blAnemia) {
		this.blAnemia = blAnemia;
	}

	/**
	 * @return the blBruising
	 */
	public boolean getBlBruising() {
		return blBruising;
	}

	/**
	 * @param blBruising the blBruising to set
	 */
	public void setBlBruising(boolean blBruising) {
		this.blBruising = blBruising;
	}

	/**
	 * @return the blClotting
	 */
	public boolean getBlClotting() {
		return blClotting;
	}

	/**
	 * @param blClotting the blClotting to set
	 */
	public void setBlClotting(boolean blClotting) {
		this.blClotting = blClotting;
	}

	/**
	 * @return the blLeukemia
	 */
	public boolean getBlLeukemia() {
		return blLeukemia;
	}

	/**
	 * @param blLeukemia the blLeukemia to set
	 */
	public void setBlLeukemia(boolean blLeukemia) {
		this.blLeukemia = blLeukemia;
	}

	/**
	 * @return the blSickleCell
	 */
	public boolean getBlSickleCell() {
		return blSickleCell;
	}

	/**
	 * @param blSickleCell the blSickleCell to set
	 */
	public void setBlSickleCell(boolean blSickleCell) {
		this.blSickleCell = blSickleCell;
	}

	/**
	 * @return the blOther
	 */
	public boolean getBlOther() {
		return blOther;
	}

	/**
	 * @param blOther the blOther to set
	 */
	public void setBlOther(boolean blOther) {
		this.blOther = blOther;
	}

	/**
	 * @return the baArthritis
	 */
	public boolean getBaArthritis() {
		return baArthritis;
	}

	/**
	 * @param baArthritis the baArthritis to set
	 */
	public void setBaArthritis(boolean baArthritis) {
		this.baArthritis = baArthritis;
	}

	/**
	 * @return the baFibromyalgia
	 */
	public boolean getBaFibromyalgia() {
		return baFibromyalgia;
	}

	/**
	 * @param baFibromyalgia the baFibromyalgia to set
	 */
	public void setBaFibromyalgia(boolean baFibromyalgia) {
		this.baFibromyalgia = baFibromyalgia;
	}

	/**
	 * @return the baJointPain
	 */
	public boolean getBaJointPain() {
		return baJointPain;
	}

	/**
	 * @param baJointPain the baJointPain to set
	 */
	public void setBaJointPain(boolean baJointPain) {
		this.baJointPain = baJointPain;
	}

	/**
	 * @return the baLymeDisease
	 */
	public boolean getBaLymeDisease() {
		return baLymeDisease;
	}

	/**
	 * @param baLymeDisease the baLymeDisease to set
	 */
	public void setBaLymeDisease(boolean baLymeDisease) {
		this.baLymeDisease = baLymeDisease;
	}

	/**
	 * @return the baOther
	 */
	public boolean getBaOther() {
		return baOther;
	}

	/**
	 * @param baOther the baOther to set
	 */
	public void setBaOther(boolean baOther) {
		this.baOther = baOther;
	}

	/**
	 * @return the caBreast
	 */
	public boolean getCaBreast() {
		return caBreast;
	}

	/**
	 * @param caBreast the caBreast to set
	 */
	public void setCaBreast(boolean caBreast) {
		this.caBreast = caBreast;
	}

	/**
	 * @return the caBowel
	 */
	public boolean getCaBowel() {
		return caBowel;
	}

	/**
	 * @param caBowel the caBowel to set
	 */
	public void setCaBowel(boolean caBowel) {
		this.caBowel = caBowel;
	}

	/**
	 * @return the caColon
	 */
	public boolean getCaColon() {
		return caColon;
	}

	/**
	 * @param caColon the caColon to set
	 */
	public void setCaColon(boolean caColon) {
		this.caColon = caColon;
	}

	/**
	 * @return the caLung
	 */
	public boolean getCaLung() {
		return caLung;
	}

	/**
	 * @param caLung the caLung to set
	 */
	public void setCaLung(boolean caLung) {
		this.caLung = caLung;
	}

	/**
	 * @return the caOvarian
	 */
	public boolean getCaOvarian() {
		return caOvarian;
	}

	/**
	 * @param caOvarian the caOvarian to set
	 */
	public void setCaOvarian(boolean caOvarian) {
		this.caOvarian = caOvarian;
	}

	/**
	 * @return the caSkin
	 */
	public boolean getCaSkin() {
		return caSkin;
	}

	/**
	 * @param caSkin the caSkin to set
	 */
	public void setCaSkin(boolean caSkin) {
		this.caSkin = caSkin;
	}

	/**
	 * @return the caStomach
	 */
	public boolean getCaStomach() {
		return caStomach;
	}

	/**
	 * @param caStomach the caStomach to set
	 */
	public void setCaStomach(boolean caStomach) {
		this.caStomach = caStomach;
	}

	/**
	 * @return the caProstate
	 */
	public boolean getCaProstate() {
		return caProstate;
	}

	/**
	 * @param caProstate the caProstate to set
	 */
	public void setCaProstate(boolean caProstate) {
		this.caProstate = caProstate;
	}

	/**
	 * @return the caOther
	 */
	public boolean getCaOther() {
		return caOther;
	}

	/**
	 * @param caOther the caOther to set
	 */
	public void setCaOther(boolean caOther) {
		this.caOther = caOther;
	}

	/**
	 * @return the chChickenPox
	 */
	public boolean getChChickenPox() {
		return chChickenPox;
	}

	/**
	 * @param chChickenPox the chChickenPox to set
	 */
	public void setChChickenPox(boolean chChickenPox) {
		this.chChickenPox = chChickenPox;
	}

	/**
	 * @return the chDiphtheria
	 */
	public boolean getChDiphtheria() {
		return chDiphtheria;
	}

	/**
	 * @param chDiphtheria the chDiphtheria to set
	 */
	public void setChDiphtheria(boolean chDiphtheria) {
		this.chDiphtheria = chDiphtheria;
	}

	/**
	 * @return the chMeasles
	 */
	public boolean getChMeasles() {
		return chMeasles;
	}

	/**
	 * @param chMeasles the chMeasles to set
	 */
	public void setChMeasles(boolean chMeasles) {
		this.chMeasles = chMeasles;
	}

	/**
	 * @return the chMumps
	 */
	public boolean getChMumps() {
		return chMumps;
	}

	/**
	 * @param chMumps the chMumps to set
	 */
	public void setChMumps(boolean chMumps) {
		this.chMumps = chMumps;
	}

	/**
	 * @return the chWhoopingCough
	 */
	public boolean getChWhoopingCough() {
		return chWhoopingCough;
	}

	/**
	 * @param chWhoopingCough the chWhoopingCough to set
	 */
	public void setChWhoopingCough(boolean chWhoopingCough) {
		this.chWhoopingCough = chWhoopingCough;
	}

	/**
	 * @return the chOther
	 */
	public boolean getChOther() {
		return chOther;
	}

	/**
	 * @param chOther the chOther to set
	 */
	public void setChOther(boolean chOther) {
		this.chOther = chOther;
	}

	/**
	 * @return the dbType1
	 */
	public boolean getDbType1() {
		return dbType1;
	}

	/**
	 * @param dbType1 the dbType1 to set
	 */
	public void setDbType1(boolean dbType1) {
		this.dbType1 = dbType1;
	}

	/**
	 * @return the dbType2
	 */
	public boolean getDbType2() {
		return dbType2;
	}

	/**
	 * @param dbType2 the dbType2 to set
	 */
	public void setDbType2(boolean dbType2) {
		this.dbType2 = dbType2;
	}

	/**
	 * @return the dbType3
	 */
	public boolean getDbType3() {
		return dbType3;
	}

	/**
	 * @param dbType3 the dbType3 to set
	 */
	public void setDbType3(boolean dbType3) {
		this.dbType3 = dbType3;
	}

	/**
	 * @return the gbDisease
	 */
	public boolean getGbDisease() {
		return gbDisease;
	}

	/**
	 * @param gbDisease the gbDisease to set
	 */
	public void setGbDisease(boolean gbDisease) {
		this.gbDisease = gbDisease;
	}

	/**
	 * @return the gbStones
	 */
	public boolean getGbStones() {
		return gbStones;
	}

	/**
	 * @param gbStones the gbStones to set
	 */
	public void setGbStones(boolean gbStones) {
		this.gbStones = gbStones;
	}

	/**
	 * @return the gbOther
	 */
	public boolean getGbOther() {
		return gbOther;
	}

	/**
	 * @param gbOther the gbOther to set
	 */
	public void setGbOther(boolean gbOther) {
		this.gbOther = gbOther;
	}

	/**
	 * @return the hntCataracts
	 */
	public boolean getHntCataracts() {
		return hntCataracts;
	}

	/**
	 * @param hntCataracts the hntCataracts to set
	 */
	public void setHntCataracts(boolean hntCataracts) {
		this.hntCataracts = hntCataracts;
	}

	/**
	 * @return the hntDizziness
	 */
	public boolean getHntDizziness() {
		return hntDizziness;
	}

	/**
	 * @param hntDizziness the hntDizziness to set
	 */
	public void setHntDizziness(boolean hntDizziness) {
		this.hntDizziness = hntDizziness;
	}

	/**
	 * @return the hntDyslexia
	 */
	public boolean getHntDyslexia() {
		return hntDyslexia;
	}

	/**
	 * @param hntDyslexia the hntDyslexia to set
	 */
	public void setHntDyslexia(boolean hntDyslexia) {
		this.hntDyslexia = hntDyslexia;
	}

	/**
	 * @return the hntGlaucoma
	 */
	public boolean getHntGlaucoma() {
		return hntGlaucoma;
	}

	/**
	 * @param hntGlaucoma the hntGlaucoma to set
	 */
	public void setHntGlaucoma(boolean hntGlaucoma) {
		this.hntGlaucoma = hntGlaucoma;
	}

	/**
	 * @return the hntHearingLoss
	 */
	public boolean getHntHearingLoss() {
		return hntHearingLoss;
	}

	/**
	 * @param hntHearingLoss the hntHearingLoss to set
	 */
	public void setHntHearingLoss(boolean hntHearingLoss) {
		this.hntHearingLoss = hntHearingLoss;
	}

	/**
	 * @return the hntMigraineHeadaches
	 */
	public boolean getHntMigraineHeadaches() {
		return hntMigraineHeadaches;
	}

	/**
	 * @param hntMigraineHeadaches the hntMigraineHeadaches to set
	 */
	public void setHntMigraineHeadaches(boolean hntMigraineHeadaches) {
		this.hntMigraineHeadaches = hntMigraineHeadaches;
	}

	/**
	 * @return the hntRetinitisPigmentosa
	 */
	public boolean getHntRetinitisPigmentosa() {
		return hntRetinitisPigmentosa;
	}

	/**
	 * @param hntRetinitisPigmentosa the hntRetinitisPigmentosa to set
	 */
	public void setHntRetinitisPigmentosa(boolean hntRetinitisPigmentosa) {
		this.hntRetinitisPigmentosa = hntRetinitisPigmentosa;
	}

	/**
	 * @return the hntOther
	 */
	public boolean getHntOther() {
		return hntOther;
	}

	/**
	 * @param hntOther the hntOther to set
	 */
	public void setHntOther(boolean hntOther) {
		this.hntOther = hntOther;
	}

	/**
	 * @return the heAngina
	 */
	public boolean getHeAngina() {
		return heAngina;
	}

	/**
	 * @param heAngina the heAngina to set
	 */
	public void setHeAngina(boolean heAngina) {
		this.heAngina = heAngina;
	}

	/**
	 * @return the heCongestiveFailure
	 */
	public boolean getHeCongestiveFailure() {
		return heCongestiveFailure;
	}

	/**
	 * @param heCongestiveFailure the heCongestiveFailure to set
	 */
	public void setHeCongestiveFailure(boolean heCongestiveFailure) {
		this.heCongestiveFailure = heCongestiveFailure;
	}

	/**
	 * @return the heAttack
	 */
	public boolean getHeAttack() {
		return heAttack;
	}

	/**
	 * @param heAttack the heAttack to set
	 */
	public void setHeAttack(boolean heAttack) {
		this.heAttack = heAttack;
	}

	/**
	 * @return the heMurmur
	 */
	public boolean getHeMurmur() {
		return heMurmur;
	}

	/**
	 * @param heMurmur the heMurmur to set
	 */
	public void setHeMurmur(boolean heMurmur) {
		this.heMurmur = heMurmur;
	}

	/**
	 * @return the heHighCholesterol
	 */
	public boolean getHeHighCholesterol() {
		return heHighCholesterol;
	}

	/**
	 * @param heHighCholesterol the heHighCholesterol to set
	 */
	public void setHeHighCholesterol(boolean heHighCholesterol) {
		this.heHighCholesterol = heHighCholesterol;
	}

	/**
	 * @return the heHighPressure
	 */
	public boolean getHeHighPressure() {
		return heHighPressure;
	}

	/**
	 * @param heHighPressure the heHighPressure to set
	 */
	public void setHeHighPressure(boolean heHighPressure) {
		this.heHighPressure = heHighPressure;
	}

	/**
	 * @return the heMitralValveProlapse
	 */
	public boolean getHeMitralValveProlapse() {
		return heMitralValveProlapse;
	}

	/**
	 * @param heMitralValveProlapse the heMitralValveProlapse to set
	 */
	public void setHeMitralValveProlapse(boolean heMitralValveProlapse) {
		this.heMitralValveProlapse = heMitralValveProlapse;
	}

	/**
	 * @return the heRhythmAbnormality
	 */
	public boolean getHeRhythmAbnormality() {
		return heRhythmAbnormality;
	}

	/**
	 * @param heRhythmAbnormality the heRhythmAbnormality to set
	 */
	public void setHeRhythmAbnormality(boolean heRhythmAbnormality) {
		this.heRhythmAbnormality = heRhythmAbnormality;
	}

	/**
	 * @return the heStroke
	 */
	public boolean getHeStroke() {
		return heStroke;
	}

	/**
	 * @param heStroke the heStroke to set
	 */
	public void setHeStroke(boolean heStroke) {
		this.heStroke = heStroke;
	}

	/**
	 * @return the heOther
	 */
	public boolean getHeOther() {
		return heOther;
	}

	/**
	 * @param heOther the heOther to set
	 */
	public void setHeOther(boolean heOther) {
		this.heOther = heOther;
	}

	/**
	 * @return the kiInfections
	 */
	public boolean getKiInfections() {
		return kiInfections;
	}

	/**
	 * @param kiInfections the kiInfections to set
	 */
	public void setKiInfections(boolean kiInfections) {
		this.kiInfections = kiInfections;
	}

	/**
	 * @return the kiStones
	 */
	public boolean getKiStones() {
		return kiStones;
	}

	/**
	 * @param kiStones the kiStones to set
	 */
	public void setKiStones(boolean kiStones) {
		this.kiStones = kiStones;
	}

	/**
	 * @return the kiRenalFailure
	 */
	public boolean getKiRenalFailure() {
		return kiRenalFailure;
	}

	/**
	 * @param kiRenalFailure the kiRenalFailure to set
	 */
	public void setKiRenalFailure(boolean kiRenalFailure) {
		this.kiRenalFailure = kiRenalFailure;
	}

	/**
	 * @return the kiOther
	 */
	public boolean getKiOther() {
		return kiOther;
	}

	/**
	 * @param kiOther the kiOther to set
	 */
	public void setKiOther(boolean kiOther) {
		this.kiOther = kiOther;
	}

	/**
	 * @return the liHepatitisA
	 */
	public boolean getLiHepatitisA() {
		return liHepatitisA;
	}

	/**
	 * @param liHepatitisA the liHepatitisA to set
	 */
	public void setLiHepatitisA(boolean liHepatitisA) {
		this.liHepatitisA = liHepatitisA;
	}

	/**
	 * @return the liHepatitisB
	 */
	public boolean getLiHepatitisB() {
		return liHepatitisB;
	}

	/**
	 * @param liHepatitisB the liHepatitisB to set
	 */
	public void setLiHepatitisB(boolean liHepatitisB) {
		this.liHepatitisB = liHepatitisB;
	}

	/**
	 * @return the liHepatitisC
	 */
	public boolean getLiHepatitisC() {
		return liHepatitisC;
	}

	/**
	 * @param liHepatitisC the liHepatitisC to set
	 */
	public void setLiHepatitisC(boolean liHepatitisC) {
		this.liHepatitisC = liHepatitisC;
	}

	/**
	 * @return the liCirrhosis
	 */
	public boolean getLiCirrhosis() {
		return liCirrhosis;
	}

	/**
	 * @param liCirrhosis the liCirrhosis to set
	 */
	public void setLiCirrhosis(boolean liCirrhosis) {
		this.liCirrhosis = liCirrhosis;
	}

	/**
	 * @return the liOther
	 */
	public boolean getLiOther() {
		return liOther;
	}

	/**
	 * @param liOther the liOther to set
	 */
	public void setLiOther(boolean liOther) {
		this.liOther = liOther;
	}

	/**
	 * @return the mdAnxiety
	 */
	public boolean getMdAnxiety() {
		return mdAnxiety;
	}

	/**
	 * @param mdAnxiety the mdAnxiety to set
	 */
	public void setMdAnxiety(boolean mdAnxiety) {
		this.mdAnxiety = mdAnxiety;
	}

	/**
	 * @return the mdBipolar
	 */
	public boolean getMdBipolar() {
		return mdBipolar;
	}

	/**
	 * @param mdBipolar the mdBipolar to set
	 */
	public void setMdBipolar(boolean mdBipolar) {
		this.mdBipolar = mdBipolar;
	}

	/**
	 * @return the mdDepression
	 */
	public boolean getMdDepression() {
		return mdDepression;
	}

	/**
	 * @param mdDepression the mdDepression to set
	 */
	public void setMdDepression(boolean mdDepression) {
		this.mdDepression = mdDepression;
	}

	/**
	 * @return the mdParanoia
	 */
	public boolean getMdParanoia() {
		return mdParanoia;
	}

	/**
	 * @param mdParanoia the mdParanoia to set
	 */
	public void setMdParanoia(boolean mdParanoia) {
		this.mdParanoia = mdParanoia;
	}

	/**
	 * @return the mdPTSD
	 */
	public boolean getMdPTSD() {
		return mdPTSD;
	}

	/**
	 * @param mdPTSD the mdPTSD to set
	 */
	public void setMdPTSD(boolean mdPTSD) {
		this.mdPTSD = mdPTSD;
	}

	/**
	 * @return the mdSchizophrenia
	 */
	public boolean getMdSchizophrenia() {
		return mdSchizophrenia;
	}

	/**
	 * @param mdSchizophrenia the mdSchizophrenia to set
	 */
	public void setMdSchizophrenia(boolean mdSchizophrenia) {
		this.mdSchizophrenia = mdSchizophrenia;
	}

	/**
	 * @return the mdOther
	 */
	public boolean getMdOther() {
		return mdOther;
	}

	/**
	 * @param mdOther the mdOther to set
	 */
	public void setMdOther(boolean mdOther) {
		this.mdOther = mdOther;
	}

	/**
	 * @return the nvEpilepsy
	 */
	public boolean getNvEpilepsy() {
		return nvEpilepsy;
	}

	/**
	 * @param nvEpilepsy the nvEpilepsy to set
	 */
	public void setNvEpilepsy(boolean nvEpilepsy) {
		this.nvEpilepsy = nvEpilepsy;
	}

	/**
	 * @return the nvMultipleSclerosis
	 */
	public boolean getNvMultipleSclerosis() {
		return nvMultipleSclerosis;
	}

	/**
	 * @param nvMultipleSclerosis the nvMultipleSclerosis to set
	 */
	public void setNvMultipleSclerosis(boolean nvMultipleSclerosis) {
		this.nvMultipleSclerosis = nvMultipleSclerosis;
	}

	/**
	 * @return the nvNumbness
	 */
	public boolean getNvNumbness() {
		return nvNumbness;
	}

	/**
	 * @param nvNumbness the nvNumbness to set
	 */
	public void setNvNumbness(boolean nvNumbness) {
		this.nvNumbness = nvNumbness;
	}

	/**
	 * @return the nvParalysis
	 */
	public boolean getNvParalysis() {
		return nvParalysis;
	}

	/**
	 * @param nvParalysis the nvParalysis to set
	 */
	public void setNvParalysis(boolean nvParalysis) {
		this.nvParalysis = nvParalysis;
	}

	/**
	 * @return the nvSeizures
	 */
	public boolean getNvSeizures() {
		return nvSeizures;
	}

	/**
	 * @param nvSeizures the nvSeizures to set
	 */
	public void setNvSeizures(boolean nvSeizures) {
		this.nvSeizures = nvSeizures;
	}

	/**
	 * @return the nvOther
	 */
	public boolean getNvOther() {
		return nvOther;
	}

	/**
	 * @param nvOther the nvOther to set
	 */
	public void setNvOther(boolean nvOther) {
		this.nvOther = nvOther;
	}

	/**
	 * @return the nbOnePerMonth
	 */
	public boolean getNbOnePerMonth() {
		return nbOnePerMonth;
	}

	/**
	 * @param nbOnePerMonth the nbOnePerMonth to set
	 */
	public void setNbOnePerMonth(boolean nbOnePerMonth) {
		this.nbOnePerMonth = nbOnePerMonth;
	}

	/**
	 * @return the nbOnePerWeek
	 */
	public boolean getNbOnePerWeek() {
		return nbOnePerWeek;
	}

	/**
	 * @param nbOnePerWeek the nbOnePerWeek to set
	 */
	public void setNbOnePerWeek(boolean nbOnePerWeek) {
		this.nbOnePerWeek = nbOnePerWeek;
	}

	/**
	 * @return the nbOnePerDay
	 */
	public boolean getNbOnePerDay() {
		return nbOnePerDay;
	}

	/**
	 * @param nbOnePerDay the nbOnePerDay to set
	 */
	public void setNbOnePerDay(boolean nbOnePerDay) {
		this.nbOnePerDay = nbOnePerDay;
	}

	/**
	 * @return the pnBack
	 */
	public boolean getPnBack() {
		return pnBack;
	}

	/**
	 * @param pnBack the pnBack to set
	 */
	public void setPnBack(boolean pnBack) {
		this.pnBack = pnBack;
	}

	/**
	 * @return the pnJoint
	 */
	public boolean getPnJoint() {
		return pnJoint;
	}

	/**
	 * @param pnJoint the pnJoint to set
	 */
	public void setPnJoint(boolean pnJoint) {
		this.pnJoint = pnJoint;
	}

	/**
	 * @return the pnMuscle
	 */
	public boolean getPnMuscle() {
		return pnMuscle;
	}

	/**
	 * @param pnMuscle the pnMuscle to set
	 */
	public void setPnMuscle(boolean pnMuscle) {
		this.pnMuscle = pnMuscle;
	}

	/**
	 * @return the pnLeg
	 */
	public boolean getPnLeg() {
		return pnLeg;
	}

	/**
	 * @param pnLeg the pnLeg to set
	 */
	public void setPnLeg(boolean pnLeg) {
		this.pnLeg = pnLeg;
	}

	/**
	 * @return the pnOther
	 */
	public boolean getPnOther() {
		return pnOther;
	}

	/**
	 * @param pnOther the pnOther to set
	 */
	public void setPnOther(boolean pnOther) {
		this.pnOther = pnOther;
	}

	/**
	 * @return the skEczema
	 */
	public boolean getSkEczema() {
		return skEczema;
	}

	/**
	 * @param skEczema the skEczema to set
	 */
	public void setSkEczema(boolean skEczema) {
		this.skEczema = skEczema;
	}

	/**
	 * @return the skPsoriasis
	 */
	public boolean getSkPsoriasis() {
		return skPsoriasis;
	}

	/**
	 * @param skPsoriasis the skPsoriasis to set
	 */
	public void setSkPsoriasis(boolean skPsoriasis) {
		this.skPsoriasis = skPsoriasis;
	}

	/**
	 * @return the skOther
	 */
	public boolean getSkOther() {
		return skOther;
	}

	/**
	 * @param skOther the skOther to set
	 */
	public void setSkOther(boolean skOther) {
		this.skOther = skOther;
	}

	/**
	 * @return the slInsomnia
	 */
	public boolean getSlInsomnia() {
		return slInsomnia;
	}

	/**
	 * @param slInsomnia the slInsomnia to set
	 */
	public void setSlInsomnia(boolean slInsomnia) {
		this.slInsomnia = slInsomnia;
	}

	/**
	 * @return the slApnea
	 */
	public boolean getSlApnea() {
		return slApnea;
	}

	/**
	 * @param slApnea the slApnea to set
	 */
	public void setSlApnea(boolean slApnea) {
		this.slApnea = slApnea;
	}

	/**
	 * @return the slOther
	 */
	public boolean getSlOther() {
		return slOther;
	}

	/**
	 * @param slOther the slOther to set
	 */
	public void setSlOther(boolean slOther) {
		this.slOther = slOther;
	}

	/**
	 * @return the smCurrent
	 */
	public boolean getSmCurrent() {
		return smCurrent;
	}

	/**
	 * @param smCurrent the smCurrent to set
	 */
	public void setSmCurrent(boolean smCurrent) {
		this.smCurrent = smCurrent;
	}

	/**
	 * @return the smOnePackPerDay
	 */
	public boolean getSmOnePackPerDay() {
		return smOnePackPerDay;
	}

	/**
	 * @param smOnePackPerDay the smOnePackPerDay to set
	 */
	public void setSmOnePackPerDay(boolean smOnePackPerDay) {
		this.smOnePackPerDay = smOnePackPerDay;
	}

	/**
	 * @return the smTenYears
	 */
	public boolean getSmTenYears() {
		return smTenYears;
	}

	/**
	 * @param smTenYears the smTenYears to set
	 */
	public void setSmTenYears(boolean smTenYears) {
		this.smTenYears = smTenYears;
	}

	/**
	 * @return the smTwentyYears
	 */
	public boolean getSmTwentyYears() {
		return smTwentyYears;
	}

	/**
	 * @param smTwentyYears the smTwentyYears to set
	 */
	public void setSmTwentyYears(boolean smTwentyYears) {
		this.smTwentyYears = smTwentyYears;
	}

	/**
	 * @return the stdChlamydia
	 */
	public boolean getStdChlamydia() {
		return stdChlamydia;
	}

	/**
	 * @param stdChlamydia the stdChlamydia to set
	 */
	public void setStdChlamydia(boolean stdChlamydia) {
		this.stdChlamydia = stdChlamydia;
	}

	/**
	 * @return the stdGonorrhea
	 */
	public boolean getStdGonorrhea() {
		return stdGonorrhea;
	}

	/**
	 * @param stdGonorrhea the stdGonorrhea to set
	 */
	public void setStdGonorrhea(boolean stdGonorrhea) {
		this.stdGonorrhea = stdGonorrhea;
	}

	/**
	 * @return the stdHerpes
	 */
	public boolean getStdHerpes() {
		return stdHerpes;
	}

	/**
	 * @param stdHerpes the stdHerpes to set
	 */
	public void setStdHerpes(boolean stdHerpes) {
		this.stdHerpes = stdHerpes;
	}

	/**
	 * @return the stdSyphilis
	 */
	public boolean getStdSyphilis() {
		return stdSyphilis;
	}

	/**
	 * @param stdSyphilis the stdSyphilis to set
	 */
	public void setStdSyphilis(boolean stdSyphilis) {
		this.stdSyphilis = stdSyphilis;
	}

	/**
	 * @return the stdOther
	 */
	public boolean getStdOther() {
		return stdOther;
	}

	/**
	 * @param stdOther the stdOther to set
	 */
	public void setStdOther(boolean stdOther) {
		this.stdOther = stdOther;
	}

	/**
	 * @return the stmIBS
	 */
	public boolean getStmIBS() {
		return stmIBS;
	}

	/**
	 * @param stmIBS the stmIBS to set
	 */
	public void setStmIBS(boolean stmIBS) {
		this.stmIBS = stmIBS;
	}

	/**
	 * @return the stmNausea
	 */
	public boolean getStmNausea() {
		return stmNausea;
	}

	/**
	 * @param stmNausea the stmNausea to set
	 */
	public void setStmNausea(boolean stmNausea) {
		this.stmNausea = stmNausea;
	}

	/**
	 * @return the stmPain
	 */
	public boolean getStmPain() {
		return stmPain;
	}

	/**
	 * @param stmPain the stmPain to set
	 */
	public void setStmPain(boolean stmPain) {
		this.stmPain = stmPain;
	}

	/**
	 * @return the stmSevereIndigestion
	 */
	public boolean getStmSevereIndigestion() {
		return stmSevereIndigestion;
	}

	/**
	 * @param stmSevereIndigestion the stmSevereIndigestion to set
	 */
	public void setStmSevereIndigestion(boolean stmSevereIndigestion) {
		this.stmSevereIndigestion = stmSevereIndigestion;
	}

	/**
	 * @return the stmUlcers
	 */
	public boolean getStmUlcers() {
		return stmUlcers;
	}

	/**
	 * @param stmUlcers the stmUlcers to set
	 */
	public void setStmUlcers(boolean stmUlcers) {
		this.stmUlcers = stmUlcers;
	}

	/**
	 * @return the stmOther
	 */
	public boolean getStmOther() {
		return stmOther;
	}

	/**
	 * @param stmOther the stmOther to set
	 */
	public void setStmOther(boolean stmOther) {
		this.stmOther = stmOther;
	}

	/**
	 * @return the thGoiter
	 */
	public boolean getThGoiter() {
		return thGoiter;
	}

	/**
	 * @param thGoiter the thGoiter to set
	 */
	public void setThGoiter(boolean thGoiter) {
		this.thGoiter = thGoiter;
	}

	/**
	 * @return the thTumor
	 */
	public boolean getThTumor() {
		return thTumor;
	}

	/**
	 * @param thTumor the thTumor to set
	 */
	public void setThTumor(boolean thTumor) {
		this.thTumor = thTumor;
	}

	/**
	 * @return the thOther
	 */
	public boolean getThOther() {
		return thOther;
	}

	/**
	 * @param thOther the thOther to set
	 */
	public void setThOther(boolean thOther) {
		this.thOther = thOther;
	}

	/**
	 * @return the wtOverweight
	 */
	public boolean getWtOverweight() {
		return wtOverweight;
	}

	/**
	 * @param wtOverweight the wtOverweight to set
	 */
	public void setWtOverweight(boolean wtOverweight) {
		this.wtOverweight = wtOverweight;
	}

	/**
	 * @return the wtUnderweight
	 */
	public boolean getWtUnderweight() {
		return wtUnderweight;
	}

	/**
	 * @param wtUnderweight the wtUnderweight to set
	 */
	public void setWtUnderweight(boolean wtUnderweight) {
		this.wtUnderweight = wtUnderweight;
	}

	/**
	 * @return the oplock
	 */
	public Integer getOplock() {
		return oplock;
	}

	/**
	 * @param oplock the oplock to set
	 */
	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	/**
	 * @return the userprofileId
	 */
	public Long getUserprofileId() {
		return userprofileId;
	}

	/**
	 * @param userprofileId the userprofileId to set
	 */
	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}

	/**
	 * @return the otherHealthIssues
	 */
	public List<OtherHealthIssueDTO> getOtherHealthIssues() {
		return otherHealthIssues;
	}

	/**
	 * @param otherHealthIssues the otherHealthIssues to set
	 */
	public void setOtherHealthIssues(List<OtherHealthIssueDTO> otherHealthIssues) {
		this.otherHealthIssues = otherHealthIssues;
	}
}
